﻿using System;
using System.Web.Mvc;
using DayPilot.Web.Mvc;
using DayPilot.Web.Mvc.Events.Gantt;
using DayPilot.Web.Mvc.Json;

namespace MvcApplication1.Controllers
{
    [HandleError]
    public class GanttController : Controller
    {
        public ActionResult Index()
        {
            return View();
        }

        public ActionResult Columns()
        {
            return View();
        }
        
        public ActionResult TaskCreating()
        {
            return View();
        }

        public ActionResult TaskVersions()
        {
            return View();
        }

        public ActionResult RowMoving()
        {
            return View();
        }

        public ActionResult RowSelecting()
        {
            return View();
        }

        public ActionResult RowClicking()
        {
            return View();
        }


        public ActionResult Backend()
        {
            return new Gantt().CallBack(this);
        }

        public ActionResult Edit(string id)
        {
            var e = new EventManager(this).Get(id) ?? new EventManager.Event();
            return View(e);
        }

        [AcceptVerbs(HttpVerbs.Post)]
        public ActionResult Edit(FormCollection form)
        {
            new EventManager(this).EventEdit(form["Id"], form["Text"]);
            return JavaScript(SimpleJsonSerializer.Serialize("OK"));
        }

        class Gantt : DayPilotGantt
        {
            protected override void OnInit(InitArgs e)
            {
                string key = "default";

                if (Id == "gantt_versions")
                {
                    key = "versions";
                }

                Tasks = new TaskManager(Controller, key).TaskData;
                Links = new TaskManager(Controller).LinkData;                

                ScrollTo(DateTime.Today);
                UpdateWithMessage("Welcome!");
            }

            protected override void OnBeforeCellRender(BeforeCellRenderArgs e)
            {
            }

            protected override void OnBeforeTaskRender(BeforeTaskRenderArgs e)
            {
                if (e.Row.Columns.Count == 3)
                {
                    e.Row.Columns[2].Html = (e.End - e.Start).ToString();
                }

            }

            protected override void OnRowMove(RowMoveArgs e)
            {
                // no action required for RowMoveHandling = Notify

                e.Move();
                Update();
            }

            protected override void OnRowCreate(RowCreateArgs e)
            {
                Tasks = new TaskManager(Controller).TaskData;
                Links = new TaskManager(Controller).LinkData;

                Tasks.Add(e.Text, Guid.NewGuid().ToString(), StartDate, StartDate.AddDays(1));
                
                Update();
            }

            protected override void OnTaskMove(TaskMoveArgs e)
            {
                // no action required for TaskMoveHandling = Notify
            }

            protected override void OnTaskResize(TaskResizeArgs e)
            {
                // no action required for TaskResizeHandling = Notify
            }

            protected override void OnRowClick(RowClickArgs e)
            {
                Redirect("~/Gantt/RowSelecting");
            }

            protected override void OnCommand(CommandArgs e)
            {
                switch (e.Command)
                {
                    case "showSelectedRows":
                        UpdateWithMessage("Number of selected rows: " + SelectedRows.Count);    
                        break;
                }
            }

            protected override void OnFinish()
            {
            }

        }

    }
}
