﻿using System;
using System.Data;
using System.Configuration;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using DayPilot.Web.Mvc;
using DayPilot.Web.Mvc.Enums.Gantt;
using DayPilot.Web.Mvc.Recurrence;

/// <summary>
/// Summary description for EventManager
/// </summary>
public class TaskManager
{
    private Controller controller;
    private string keyTasks;
    private string keyLinks;
    private string key;

    public TaskManager(Controller controller, string key)
    {
        this.controller = controller;
        this.key = key;
        this.keyTasks = key + "_tasks";
        this.keyLinks = key + "_links";

        if (this.controller.Session[keyTasks] == null)
        {
            this.controller.Session[keyTasks] = GenerateTaskData();
            this.controller.Session[keyLinks] = GenerateLinkData();
        }
    }

    public TaskCollection TaskData
    {
        get { return (TaskCollection) controller.Session[keyTasks]; }
    }    
    
    public LinkCollection LinkData
    {
        get { return (LinkCollection) controller.Session[keyLinks]; }
    }

    public TaskManager(Controller controller) : this(controller, "default")
    {
    }

    private TaskCollection GenerateTaskData()
    {
        TaskCollection tasks = new TaskCollection();

        Task group = tasks.AddGroup("Group 1", "G1");
        group.Children.Add(NewTask("Task 1", "1", DateTime.Today, DateTime.Today.AddDays(2)));
        group.Children.Add(NewTask("Task 2", "2", DateTime.Today, DateTime.Today.AddDays(2)));
        group.Children.AddMilestone("Milestone 1", "3", DateTime.Today.AddDays(2));

        return tasks;
    }

    private Task NewTask(string name, string id, DateTime start, DateTime end)
    {
        Task task = new Task(name, id, start, end);
        task.Tags["id"] = task.Id;
        task.Complete = 53;

        if (key == "versions")
        {
            TaskVersion v = new TaskVersion(start.AddDays(-1), end.AddDays(-1));
            v.Complete = 45;
            task.Versions.Add(v);
        }

        return task;
    }


    private LinkCollection GenerateLinkData()
    {
        LinkCollection links = new LinkCollection();

        links.Add("6", "16");  // link from Event 6 to Event 16

        return links;
    }

}
